/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Component;
import java.awt.Event;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

public class StringInput
extends TextField
implements KeyListener,
FocusListener,
JDMInput {
    private static final int DEFAULT_WIDTH = 25;
    private static final int DEFAULT_LENGTH = 1024;
    private static final String DEFAULT_VALUE = "";
    private static ResourceBundle myResources = null;
    protected boolean ignoreValue;
    protected boolean hasErrorValue;
    protected int maxlength = Integer.MAX_VALUE;

    public StringInput(String string, int n, int n2) {
        super(string, n2);
        this.maxlength = n;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.ignoreValue = false;
        this.hasErrorValue = false;
        this.setForeground(JmaColors.textText);
        ((Component)this).setBackground(JmaColors.background);
    }

    public StringInput(String string, int n) {
        this(string, 1024, n);
    }

    public StringInput(String string) {
        this(string, 1024, 25);
    }

    public StringInput() {
        this(DEFAULT_VALUE, 1024, 25);
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }

    public boolean isValidValue() {
        if (this.hasErrorValue) {
            return false;
        }
        return this.isValidValue(this.getText());
    }

    protected boolean isValidValue(String string) {
        return string.length() <= this.maxlength;
    }

    protected boolean isValidValue(char c) {
        return true;
    }

    protected boolean isValidValue(int n) {
        String string = this.getText();
        string = String.valueOf(string.substring(0, this.getSelectionStart())) + (char)n + string.substring(this.getSelectionEnd());
        return this.isValidValue(string);
    }

    protected boolean isValidValue(Event event) {
        return true;
    }

    public String stringValue() {
        return this.getText();
    }

    public Object getValue() {
        return new String(this.stringValue());
    }

    public String toString() {
        return this.getValue().toString();
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            ((TextComponent)this).setText(string);
            this.ignoreValue = false;
            this.hasErrorValue = false;
            return;
        }
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            ((TextComponent)this).setText(octetString.toDisplayString());
            this.ignoreValue = false;
            this.hasErrorValue = false;
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            ((TextComponent)this).setText(specialValue.toString());
            this.ignoreValue = object instanceof NotSupported;
            this.hasErrorValue = true;
        }
    }

    public void setValue(String string) {
        ((TextComponent)this).setText(string);
        this.ignoreValue = false;
        this.hasErrorValue = false;
    }

    public void setMaxLength(int n) {
        this.maxlength = n;
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!(c < ' ' || this.isValidValue(c) && this.isValidValue((int)c))) {
            keyEvent.consume();
        }
        this.ignoreValue = false;
        this.hasErrorValue = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isValidValue()) {
            ((TextComponent)this).setText(StringInput.euiError("valueOutOfRange"));
        }
    }

    protected static String euiError(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.EuiErrorResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

